﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="WnioskiOPraceZdalna.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.WnioskiOPraceZdalna" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Wnioski o pracę zdalną</title>
    <link href="../Web.css?2" type="text/css" rel="stylesheet" />
    <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
    <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
    <script src="../jquery/ui/i18n/jquery.ui.datepicker-pl.js" type="text/javascript"></script>
    <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
    <script type="text/javascript">
        $(function () {
            $('#tbDataOd').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
            $('#tbDataDo').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
            
            $("#tbDataOd").datepicker("option", "dateFormat", 'yy-mm-dd');
            $("#tbDataDo").datepicker("option", "dateFormat", 'yy-mm-dd');
            
            $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
            $("#btnDodaj").button({ icons: { primary: 'ui-icon-plusthick' } });
            $(".btnOtworzGrid").button({ icons: { primary: 'ui-icon-folder-open' } });

        });
    </script>
    <style>

       .minWidthData {
            min-width: 65px;
        }

    </style>
</head>
<body id="body" style="font-size: 8pt;" runat="server">
    <form id="form1" runat="server">
        <div>
            <asp:Label ID="lblError" runat="server" EnableViewState="false"></asp:Label>
            <asp:Label ID="lblKomunikat" runat="server" EnableViewState="true"></asp:Label>
            <table class="bodyLRT0" cellspacing="0" cellpadding="0" width="100%" border="0">
                <tr>
                    <td colspan="5">
                        <asp:Label ID="lblNaglowek" runat="server" Style="font-size: 12pt; font-weight: bold">Wnioski o pracę zdalną</asp:Label>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="width: 25%" valign="bottom">
                        <small>
                            <asp:Label ID="lblNazwisko" runat="server">Nazwisko</asp:Label></small><br />
                        <asp:TextBox ID="tbNazwisko" Width="95%" runat="server"></asp:TextBox>
                    </td>
                    <td colspan="2" style="width: 30%" valign="bottom">
                        <small>
                            <asp:Label ID="lblImie" runat="server">Imię</asp:Label></small><br />
                        <asp:TextBox ID="tbImie" Width="100%" runat="server"></asp:TextBox>
                    </td>
                    <td colspan="1" style="text-align: right" valign="bottom">

                    </td>
                </tr>
                <tr>
                    <td style="width: 25%" valign="bottom">
                        <small>Jednostka</small><br />
                        <asp:DropDownList ID="ddlJednostka" runat="server" Width="100%"></asp:DropDownList>
                    </td>
                    <td style="width: 15%" valign="bottom">
                        <small>od (rrrr-mm-dd)</small><br />
                        <asp:TextBox ID="tbDataOd" Width="80%" runat="server"></asp:TextBox>
                    </td>
                    <td style="width: 15%" valign="bottom">
                        <small>do (rrrr-mm-dd)</small><br />
                        <asp:TextBox ID="tbDataDo" Width="80%" runat="server"></asp:TextBox>
                    </td>
                    <td style="width: 30%" valign="bottom">
                        <small>Status</small><br />
                        <asp:DropDownList ID="ddlStatus" Width="100%" runat="server">
                            <asp:ListItem Value="0">-Wybierz status-</asp:ListItem>
                            <asp:ListItem Value="WPR">Wprowadzanie</asp:ListItem>
                            <asp:ListItem Value="DO_PRZE">Do akceptacji przełożonego</asp:ListItem>
                            <asp:ListItem Value="DO_PP">Do akceptacji przełoż. przełożonego</asp:ListItem>
                            <asp:ListItem Value="DO_ZA">Do akceptacji zarządu</asp:ListItem>
                            <asp:ListItem Selected="True" Value="NZAK">Nie zakończone</asp:ListItem>
                            <asp:ListItem Value="ODR">Odrzucony</asp:ListItem>
                            <asp:ListItem Value="ZAT">Zatwierdzony</asp:ListItem>
                            <asp:ListItem Value="ANU">Anulowany</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td style="width: 15%; text-align: right" valign="bottom">
                        <small></small>
                        <br />
                        <asp:LinkButton ID="btnOdswiez" runat="server" Text="Odśwież" Width="90px" CssClass="aspButton" OnClick="btnOdswiez_Click"></asp:LinkButton>
                    </td>
                </tr>
            </table>
        </div>
        <div>
            <asp:LinkButton ID="btnDodaj" runat="server" Text="Dodaj" Width="90px" CssClass="aspButton" OnClick="btnDodaj_Click" ></asp:LinkButton>
            <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
                <div style="float: left; position: absolute; bottom: 2px;">
                    <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
                </div>
            </div>
            <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_WNIOSKU,ID_PRACOWNIKA,ID_KTH_ALT,STATUS,IMIE,NAZWISKO,JEDNOSTKA,STANOWISKO,DATA_OD,DATA_DO,STATUS_NAZWA,PRAWO_AKCEPTACJI_ZA,PRAWO_AKCEPTACJI,PRAWO_OPINIOWANIA,PRAWO_WYSYLANIA,RODZAJ,RODZAJ_NAZWA,ADRES_ZGODNY_Z_ZAMIESZKANIA,ADRES_WYKONYWANIA_PRACY,UPRAWNIENIE,IT,LICZBA_DNI,DNI_STR" AllowPaging="True" OnRowCommand="gvListy_RowCommand" OnRowDataBound="gvListy_RowDataBound">
                <Columns>
                    <asp:TemplateField ShowHeader="False">
                        <ItemTemplate>
                            <asp:LinkButton ID="lbOtworzGrid" class="btnOtworzGrid" runat="server" CausesValidation="false" CommandName="OTWORZ" CommandArgument='<%# Container.DataItemIndex %>'  Text="Otwórz"></asp:LinkButton>
                        </ItemTemplate>
                        <ItemStyle VerticalAlign="Middle" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="NAZWISKO" HeaderText="Nazwisko" SortExpression="NAZWISKO" />
                    <asp:BoundField DataField="IMIE" HeaderText="Imię" SortExpression="IMIE" />
                    <asp:BoundField DataField="ID_KONTRAHENTA" HeaderText="Id kontrahenta(CSK)" SortExpression="ID_KONTRAHENTA" />
                    <asp:BoundField DataField="JEDNOSTKA" HeaderText="Jednostka" SortExpression="JEDNOSTKA" />
                    <asp:BoundField DataField="STANOWISKO" HeaderText="Stanowisko" SortExpression="STANOWISKO" />
                    <asp:BoundField DataField="RODZAJ_NAZWA" HeaderText="Rodzaj wniosku" SortExpression="RODZAJ_NAZWA" />
                    <asp:TemplateField HeaderText="Data od" SortExpression="DATA_OD">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox1" runat="server" Text='<%# Bind("DATA_OD") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="Label1" runat="server" Text='<%# Bind("DATA_OD", "{0:yyyy-MM-dd HH:mm}") %>'></asp:Label>
                        </ItemTemplate>
                        <ControlStyle Width="85px" />
                        <HeaderStyle Width="85px" />
                        <ItemStyle Width="85px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="Data do" SortExpression="DATA_DO">
                        <EditItemTemplate>
                            <asp:TextBox ID="TextBox2" runat="server" Text='<%# Bind("DATA_DO") %>'></asp:TextBox>
                        </EditItemTemplate>
                        <ItemTemplate>
                            <asp:Label ID="Label2" runat="server" Text='<%# Bind("DATA_DO", "{0:yyyy-MM-dd HH:mm}") %>'></asp:Label>
                        </ItemTemplate>
                        <ControlStyle Width="85px" />
                        <HeaderStyle Width="85px" />
                        <ItemStyle Width="85px" />
                    </asp:TemplateField>
                    <asp:BoundField DataField="DNI_STR" HeaderText="Dni" SortExpression="DNI_STR"  ItemStyle-CssClass="minWidthData"  />
                    <asp:BoundField DataField="LICZBA_DNI" HeaderText="Liczba dni w tyg./mies." SortExpression="LICZBA_DNI" />
                    <asp:BoundField DataField="STATUS_NAZWA" HeaderText="Status" SortExpression="STATUS_NAZWA" />
                    <asp:BoundField DataField="DATA_UTWORZENIA" HeaderText="Data dodania" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_UTWORZENIA" />
                    <asp:BoundField DataField="DATA_WYSLANIA" HeaderText="Data wysłania" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_WYSLANIA" />
                    <asp:BoundField DataField="WYSYLAJACY" HeaderText="Wysyłający" SortExpression="WYSYLAJACY" />
                    <asp:BoundField DataField="DATA_ZATWIERDZENIA_PRZELOZONY" HeaderText="Data akc. przełoż." DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ZATWIERDZENIA_PRZELOZONY" />
                    <asp:BoundField DataField="DATA_ODRZUCENIA_PRZELOZONY" HeaderText="Data odrzucenia przełoż." DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ODRZUCENIA_PRZELOZONY" />
                    <asp:BoundField DataField="PRZELOZONY" HeaderText="Przełożony" SortExpression="PRZELOZONY" />
                    <asp:BoundField DataField="DATA_ZATWIERDZENIA_PP" HeaderText="Data akc. przełoż. przełoż." DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ZATWIERDZENIA_PP" />
                    <asp:BoundField DataField="DATA_ODRZUCENIA_PP" HeaderText="Data odrzucenia przełoż. przełoż." DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ODRZUCENIA_PP" />
                    <asp:BoundField DataField="ZATWIERDZAJACY_PP" HeaderText="Przełoż. przełożonego" SortExpression="ZATWIERDZAJACY_PP" />
                    <asp:BoundField DataField="DATA_ZATWIERDZENIA_ZA" HeaderText="Data akc. zarządu" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ZATWIERDZENIA_ZA" />
                    <asp:BoundField DataField="DATA_ODRZUCENIA_ZA" HeaderText="Data odrzucenia zarząd" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ODRZUCENIA_ZA" />
                    <asp:BoundField DataField="ZATWIERDZAJACY_ZA" HeaderText="Zarząd" SortExpression="ZATWIERDZAJACY_ZA" />
                    <asp:BoundField DataField="DATA_ANULOWANIA" HeaderText="Data anulowania" DataFormatString="{0:yyyy-MM-dd HH:mm}" SortExpression="DATA_ANULOWANIA" />
                    <asp:BoundField DataField="ANULUJACY" HeaderText="Anulujący" SortExpression="ANULUJACY" />
                </Columns>
                <PagerSettings Position="Top" />
                <RowStyle CssClass="TableItem" />
                <SelectedRowStyle CssClass="TableItemSelected" />
                <HeaderStyle CssClass="TableHeader" />
                <AlternatingRowStyle CssClass="TableItemAlt" />
            </asp:GridView>
            <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="WNIOSKI_O_PRACE_ZDALNA_LIST" SelectCommandType="StoredProcedure" ConnectionString="" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected">
                <SelectParameters>
                    <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
                    <asp:ControlParameter ControlID="tbNazwisko" Name="P_NAZWISKO" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    <asp:ControlParameter ControlID="tbImie" Name="P_IMIE" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
                    <asp:ControlParameter ControlID="tbDataOd" Name="P_DATA_OD" PropertyName="Text" Type="DateTime" />
                    <asp:ControlParameter ControlID="tbDataDo" Name="P_DATA_DO" PropertyName="Text" Type="DateTime" />
                    <asp:ControlParameter ControlID="ddlStatus" Name="P_STATUS" PropertyName="SelectedValue" Type="String" />
                    <asp:ControlParameter ControlID="ddlJednostka" Name="P_ID_MPZ" PropertyName="SelectedValue" />
                </SelectParameters>
            </asp:SqlDataSource>
        </div>
    </form>
</body>
</html>

